/* 
Copyright  2010 
   Dauger Research, Inc. 
   http://daugerresearch.com/
   
   Dauger Research, Inc., provides this code on an as-is basis.
   No warranty or guarantee is implied. 
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <time.h>
#include <math.h>

#include "fileutil.c"

#define MaxNameLength			64L
#define MaxSampleCount			(1L<<11)

typedef struct TemperatureSampleStruct {
	short h, m; 
	float temp; 
	} TemperatureSampleStruct, *TemperatureSamplePtr; 

typedef struct IntraDayStruct {
	char name[MaxNameLength]; 
/*	struct {
		int min; 
		float temp; 
		} min; 
	struct {
		int min; 
		float temp; 
		} max; 
	struct {
		double sum, sum2; for deviation
		int count; 
		} ave; 
	struct {
		histogram[BinCount]; 5kB instead of 176kB
		} median; */
	TemperatureSampleStruct data[MaxSampleCount]; 
	} IntraDayStruct, *IntraDayPtr; 
	
#define MaxMonitorCount			32L

IntraDayPtr daily[MaxMonitorCount]={NULL}; 

#pragma mark every day

int CompareTemperatureSample(const void *x, const void *y)
	{
#define a		((TemperatureSamplePtr)x)
#define b		((TemperatureSamplePtr)y)
	return (a->temp>b->temp)?1:(a->temp<b->temp)?-1:0; 
#undef a
#undef b
	}

#define LogDirectory	"/Library/Logs/Temperature/"

void savetemperaturedata(struct tm *tm, IntraDayPtr p)
	{/* data reduction */
	if (tm) {
		if (p) {
			int i, count; 
			double sum=0, sum2=0, max=p->data[0].temp, min=p->data[0].temp; 
			int maxi=0, mini=0; 
			FILE *fp; 
			char logfilename[256]={0}; 
			mkdir(LogDirectory, 0777); 
			for(i=0; (i<MaxSampleCount)&&p->data[i].temp; i++) {
				sum+=p->data[i].temp; 
				sum2+=p->data[i].temp*p->data[i].temp; 
				if (p->data[i].temp>max) {
					max=p->data[i].temp; 
					maxi=i; 
					}
				if (p->data[i].temp<min) {
					min=p->data[i].temp; 
					mini=i; 
					}
				}
			count=i; 
			strcpy(logfilename, LogDirectory); 
			strcat(logfilename, p->name); 
			fp=fopen(logfilename, "a+"); 
			if (fp) {
				float average=sum/count, deviation=sqrt((sum2/count)-average*average); 
				fprintf(fp, "%d,%d,%d,%d,", tm->tm_year-100, tm->tm_mon+1, tm->tm_mday, tm->tm_yday); 
				fprintf(fp, "%f,%d,%d,", max, p->data[maxi].h, p->data[maxi].m); 
				fprintf(fp, "%f,%d,%d,", min, p->data[mini].h, p->data[mini].m); 
				fprintf(fp, "%f,%f,", average, deviation); 
				//median
				qsort(p->data, count, sizeof(TemperatureSampleStruct), 
					CompareTemperatureSample); 
				
				fprintf(fp, "%f\n", p->data[count>>1].temp); 
				fclose(fp); 
				}
			
			//clear
			memset(p->data, 0, sizeof(TemperatureSampleStruct)*MaxSampleCount); 
			}
		}
	}

#pragma mark every minute

void rememberdata(char *name, int h, int m, float value) 
	{
	if (name&&(value>0)) {
		int i; 
		IntraDayPtr p=NULL; 
		for(i=0; (i<MaxMonitorCount)&&daily[i]&&!p; i++) {
			if (!strcmp(daily[i]->name, name))
				p=daily[i]; 
			}
		if (!p) {
			if (i<MaxMonitorCount) {
				//set up a new one
				p=daily[i]=malloc(sizeof(IntraDayStruct)); 
				if (p) {
					memset(p, 0, sizeof(IntraDayStruct)); 
					strncpy(p->name, name, MaxNameLength-1); 
					}
				}
			//else can't help you
			}
		if (p) {
			for(i=0; (i<MaxSampleCount)&&p->data[i].temp; i++) 
				; //locate where to write
			if (i<MaxSampleCount) {
				p->data[i].temp=value; 
				p->data[i].h=h; 
				p->data[i].m=m; 
				}
			}
		}
	}

int verbose=0; 

#define SensorBaseS		"xserve:Status:Sensors:_array_index:%d:"
#define TypeS			SensorBaseS"type = \""
#define TemperatureS	TypeS"temperature"
#define NameS			SensorBaseS"location = \""
#define ValueS			SensorBaseS"current-value = "

void parsetemperaturedata(char *data, int h, int m); 
void parsetemperaturedata(char *data, int h, int m)
	{
	if (data) {
		int i; 
		char testS[128]; 
		for(i=0; i<44; i++) {
			char *tp; 
			sprintf(testS, TemperatureS, i); 
			tp=strstr(data, testS); 
			if (tp) {//temperature candidate found
				sprintf(testS, NameS, i); 
				tp=strstr(data, testS); 
				if (tp) {//name found
					char name[128]; 
					tp+=strlen(testS); 
					strncpy(name, tp, 64); 
					tp=strchr(name, '\"'); 
					if (tp) tp[0]=0; 
					
					sprintf(testS, ValueS, i); 
					tp=strstr(data, testS); 
					if (tp) {//value found
						float value=0; 
						tp+=strlen(testS); 
						sscanf(tp, "%f", &value); 
						value/=65536.0; 
						/* value at h, m with name */
						if(verbose)printf("%s\t%f C\n", name, value); 
						rememberdata(name, h, m, value); 
						}
					}
				}
			}
		
		}
	}
	
/* Name (t min, C min) (t max, C max) C average C median */

#define TemporaryFileNameS		"/tmp/temptemp.txt"
#define CommandS				"sudo serveradmin command xserve:command = status >> "TemporaryFileNameS

int main(int argc, char **argv)
	{short looping=10; 
	int lastHour=0; 
	struct tm lastTm; 
	if(verbose)printf("Hell world!\n"); 
	
	sleep(3);
	
	do {
		char *rawdata; 
		system(CommandS); //in retrospect I could've used popen()
		
		rawdata=readfromfile(TemporaryFileNameS); 
	
		if (rawdata) {
			time_t currentTime; 
			struct tm *currTm; 
			time(&currentTime); 
			currTm=localtime(&currentTime); 
			
			if (currTm->tm_hour<lastHour) {//brand new day
				int i; 
				for(i=0; i<MaxMonitorCount; i++) 
					savetemperaturedata(&lastTm, daily[i]); 
				}
			lastHour=currTm->tm_hour; 
			lastTm=currTm[0]; 
			
			if(verbose)printf("%dh %dm\n", currTm->tm_hour, currTm->tm_min); 
			parsetemperaturedata(rawdata, currTm->tm_hour, currTm->tm_min); 
			
			free(rawdata); 
			remove(TemporaryFileNameS); 
			rawdata=NULL; 
			}
		else {
			printf("could not read data\n"); 
			looping--; 
			}
		
		if (looping) 
			sleep(60); 
		
		} while (looping); 
	
	return 0; 
	}

